/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.feature;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmSounds;
import svenhjol.charm.world.client.render.RenderSpectre;
import svenhjol.charm.world.entity.EntitySpectre;
import svenhjol.charm.world.message.MessageSpectreDespawn;
import svenhjol.meson.Feature;
import svenhjol.meson.handler.NetworkHandler;
import svenhjol.meson.helper.EntityHelper;
import svenhjol.meson.helper.SoundHelper;

public class Spectre
extends Feature {
    public static int weight;
    public static int min;
    public static int max;
    public static int despawnLight;
    public static int trackingRange;
    public static int spawnDepth;
    public static int weaknessDuration;
    public static int weaknessAmplifier;
    public static float maxHealth;
    public static float attackDamage;
    public static float movementSpeed;
    public static boolean applyCurse;
    public static int eggColor1;
    public static int eggColor2;

    @Override
    public String getDescription() {
        return "Spectres spawn in the darkness at quite a low depth, and are almost invisible to see.\nWhen they touch the player they curse a weapon, tool or armor item and disappear.\nThey can be defeated by light and convert sand to soul sand on death.";
    }

    @Override
    public void configure() {
        super.configure();
        despawnLight = MathHelper.func_76125_a((int)this.propInt("Despawn light level", "Light level at which a Spectre disappears.", 8), (int)1, (int)16);
        spawnDepth = this.propInt("Spawn depth", "Maximum depth at which Spectres can spawn.", 24);
        weight = this.propInt("Spawn weight", "The higher this value, the more Spectres will spawn.", 100);
        applyCurse = this.propBoolean("Apply curse", "If true, spectres will curse armor or items belonging to the player.\nIf false, spectres will apply a weakness effect.", false);
        eggColor1 = 0xECECEC;
        eggColor2 = 16772477;
        maxHealth = 0.5f;
        attackDamage = 0.01f;
        movementSpeed = 0.19f;
        min = 4;
        max = 8;
        trackingRange = 100;
        weaknessDuration = 2;
        weaknessAmplifier = 1;
        if (despawnLight == 0) {
            despawnLight = 1;
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        String name = "charm:spectre";
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(name), EntitySpectre.class, (String)name, (int)2, (Object)Charm.instance, (int)trackingRange, (int)3, (boolean)true, (int)eggColor1, (int)eggColor2);
        LootTableList.func_186375_a((ResourceLocation)EntitySpectre.LOOT_TABLE);
        NetworkHandler.register(MessageSpectreDespawn.class, Side.CLIENT);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        EntityRegistry.addSpawn(EntitySpectre.class, (int)weight, (int)min, (int)max, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])EntityHelper.getBiomesWithMob(EntityZombie.class));
    }

    @Override
    public void preInitClient(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntitySpectre.class, (IRenderFactory)RenderSpectre.FACTORY);
    }

    @SideOnly(value=Side.CLIENT)
    public static void effectDespawn(BlockPos pos) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        for (int i = 0; i < 8; ++i) {
            double d0 = world.field_73012_v.nextGaussian() * 0.02;
            double d1 = world.field_73012_v.nextGaussian() * 0.02;
            double d2 = world.field_73012_v.nextGaussian() * 0.02;
            double dx = (float)pos.func_177958_n() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
            double dy = (float)pos.func_177956_o() + 0.65f + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)1.0f);
            double dz = (float)pos.func_177952_p() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
            world.func_175688_a(EnumParticleTypes.CLOUD, dx, dy, dz, d0, d1, d2, new int[0]);
        }
        SoundHelper.playSoundAtPos((World)world, pos, CharmSounds.SPECTRE_HIT_NO_SUBTITLE, SoundCategory.HOSTILE, 0.2f - world.field_73012_v.nextFloat() / 4.0f, 1.25f - world.field_73012_v.nextFloat() / 4.0f);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

